<?php
	defined( 'ABSPATH' ) || exit;

	global $current_user;

	$is_custom_content = apply_filters('betheme_dashboard_content', 'filter_me') !== 'filter_me';
?>

<div id="mfn-dashboard" class="mfn-ui mfn-dashboard" data-page="dashboard">

	<input type="hidden" name="mfn-builder-nonce" value="<?php echo wp_create_nonce( 'mfn-builder-nonce' ); ?>">

	<?php
		// header
		include_once get_theme_file_path('/functions/admin/templates/parts/header.php');
	?>

	<div class="mfn-wrapper">

		<?php
			// subheader
			$current = 'dashboard';
			include_once get_theme_file_path('/functions/admin/templates/parts/subheader.php');
		?>

		<div class="mfn-dashboard-wrapper">

			<?php if ( $is_custom_content ): ?>

				<?php echo stripslashes(apply_filters('betheme_dashboard_content', '')); ?>

			<?php else: ?>

				<?php if( ! mfn_is_registered() ): ?>

					<div class="mfn-row">

						<div class="row-column row-column-8">

							<div class="mfn-card mfn-shadow-1" data-card="theme-register">

							<div class="card-header">
								<div class="card-title-group">
									<span class="card-icon mfn-icon-register-light"></span>
									<div class="card-desc">
										<h4 class="card-title">ثبت قالب</h4>
									</div>
								</div>
								<?php if( ! WHITE_LABEL ): ?>
								<div class="card-links-group">
									<a href="#" class="data-collection" data-modal="data-collection"><span class="mfn-icon mfn-icon-support-light"></span> اطلاعات</a>
									<a target="_blank" href="https://www.zhaket.com/web/betheme-responsive-multi-purpose"><span class="mfn-icon mfn-icon-folder-open-light"></span> خرید قالب بی تم</a>
								</div>
								<?php endif; ?>
							</div>

								<div class="card-content">
									<form class="form-register mfn-form mfn-form-reg" method="post">

										<input type="hidden" name="mfn-setup-nonce" value="<?php echo wp_create_nonce( 'mfn-setup-register' ); ?>">
						        <input type="hidden" name="mfn-builder-nonce" value="<?php echo wp_create_nonce( 'mfn-builder-nonce' ); ?>">
						        <input type="hidden" name="action" value="mfn_setup_register">
						        <input type="submit" name="submit" value="mfn_setup_register" style="display:none">

										<div class="form-register-input">

										<span class="mfn-icon mfn-icon-password-light"></span>
										<input type="text" name="code" placeholder="با ثبت قالب این بخش خودکار پر خواهد شد" class="mfn-form-control of-input" size="36">

										<div class="mfn-tooltip-box where-is">
											<a>کد کجاست ؟</a>
											<div class="tooltip-box-inner">
												<p><strong>کلید لایسنس من کجا قرار دارد ؟</strong></p>
												<ol>
													<li>برو به  <a target="_blank" href="https://www.zhaket.com/web/betheme-responsive-multi-purpose">بخش دانلود های ژآکت</a></li>
													<li>در <strong>بین محصولات خرید شده</strong>  بی تم را پیدا کنید</li>
													<li>لایسنس را <strong>کپی نمائید</strong></li>
												</ol>
											</div>
										</div>

										<span class="form-message">اینجا وارد نکنید ! ثبت لایسنس در : پیشخوان » تنظیمات وردپرس » ثبت قالب بی انجام میشود</span>

										</div>

									<a id="register" class="mfn-btn mfn-btn-fw mfn-btn-green"><span class="btn-wrapper">ثبت قالب</span></a>

									</form>

									<?php
										// new license
										include get_theme_file_path('/functions/admin/templates/parts/new-license.php');
									?>

								</div>
							</div>

						</div>

						<div class="row-column row-column-4">

							<?php
								// mini system status
								include get_theme_file_path('/functions/admin/templates/parts/mini-status.php');

								// suggestion
								include get_theme_file_path('/functions/admin/templates/parts/suggestion.php');
							?>

						</div>

					</div>

				<?php endif; ?>

				<?php
					$disable = mfn_opts_get('theme-disable');

					if( ! WHITE_LABEL && ! isset($disable['demo-data']) ):
				?>

	      <div class="mfn-row">

        <div class="row-column row-column-4">
          <div class="mfn-card mfn-shadow-1" data-card="setup-wizard">
            <div class="card-content">
              <h3>مرحله به مرحله<br /> برای ساخت وب سایت</h3>
              <p>تیم پرو استایل توضیح لازم را به شما خواهد داد</p>
              <a class="mfn-btn" href="admin.php?page=be-setup"><span class="btn-wrapper">برو به بخش نصب آسان</span></a>
            </div>
          </div>
        </div>

	        <div class="row-column row-column-8">
	          <div class="mfn-card mfn-shadow-1" data-card="news-carousel">
	            <div class="card-content">
	              <!-- <ul class="slider-promo">
	                <li><a href="#"><img src="https://api.muffingroup.com/promo/images/26.jpg" alt="" /></a></li>
	                <li><a href="#"><img src="https://api.muffingroup.com/promo/images/26.jpg" alt="" /></a></li>
	              </ul> -->
								<?php $this->promo(); ?>
	            </div>
	          </div>
	        </div>

	      </div>

				<?php
					// latest websites
					include_once get_theme_file_path('/functions/admin/templates/parts/websites.php');
				?>

				<?php endif; ?>

				<?php if( mfn_is_registered() ): ?>

					<div class="mfn-row">

						<div class="row-column row-column-8">

							<div class="mfn-card mfn-shadow-1" data-card="theme-register">

							<div class="card-header">
								<div class="card-title-group">
									<span class="card-icon mfn-icon-register-light"></span>
									<div class="card-desc">
										<h4 class="card-title">ثبت قالب</h4>
									</div>
								</div>
								<div class="card-links-group">
									<a href="#" class="data-collection" data-modal="data-collection"><span class="mfn-icon mfn-icon-support-light"></span> دیتا کالکشن</a>
									<a target="_blank" href="https://www.zhaket.com/web/betheme-responsive-multi-purpose"><span class="mfn-icon mfn-icon-folder-open-light"></span> بررسی لایسنس</a>
								</div>
							</div>

								<div class="card-content">

									<form class="form-register mfn-form" method="post">
										<div class="form-register-input">

											<span class="mfn-icon mfn-icon-password-light"></span>
											<input type="text" value="<?php echo esc_html( mfn_get_purchase_code_hidden() ); ?>" class="mfn-form-control of-input" size="36" readonly="readonly">

										<a id="deregister" class="mfn-btn mfn-btn-green deregister-theme"><span class="btn-wrapper">حذف لایسنس </span></a>

										</div>
									</form>

									<?php
										// new license
										include get_theme_file_path('/functions/admin/templates/parts/new-license.php');
									?>

								</div>

							</div>

						</div>

						<div class="row-column row-column-4">

							<?php
								// mini system status
								include get_theme_file_path('/functions/admin/templates/parts/mini-status.php');

								// suggestion
								include get_theme_file_path('/functions/admin/templates/parts/suggestion.php');
							?>

						</div>

					</div>

				<?php endif; ?>

				<?php if( ! WHITE_LABEL ): ?>

				<div class="mfn-row">
					<div class="row-column row-column-12">

						<div class="mfn-card mfn-shadow-1" data-card="performance">
							<div class="card-header">
								<div class="card-title-group">
									<span class="card-icon mfn-icon-performance"></span>
									<div class="card-desc">
										<h4 class="card-title">تنظیمات بهینه سازی</h4>
									</div>
								</div>
								<div class="card-logos-group">
                  <img class="logo-pagespeed" src="<?php echo get_theme_file_uri('/functions/admin/assets/svg/logo-pagespeed-insights.svg'); ?>" width="35" alt="PageSpeed Insights" />
                  <img class="logo-gtmetrix" src="<?php echo get_theme_file_uri('/functions/admin/assets/svg/logo-gtmetrix.svg'); ?>" width="100" alt="GTmetrix" />
								</div>
								<div class="card-buttons-group">
                  <a class="mfn-btn mfn-btn-blue" href="admin.php?page=<?php echo apply_filters('betheme_slug', 'be'); ?>-options#performance-general">
                    <span class="btn-wrapper">بهبود اجرای سایت</span>
                  </a>
								</div>
							</div>
						</div>

					</div>
				</div>

	      <div class="mfn-row">
	        <div class="row-column row-column-12">
	          <div class="mfn-card mfn-shadow-1" data-card="siteground">
	            <div class="card-content">
                <div class="banner-content">
                  <h3>خرید افزونه سئو پرو استایل </h3>
                  <a target="_blank" href="https://www.zhaket.com/store/web/pchelper">سازگاری با قالب بی و هاست های محبوب</a>
                </div>
                <img class="be-siteground" src="<?php echo get_theme_file_uri('/functions/admin/assets/images/siteground.webp'); ?>" alt="Prostyle" />
	            </div>
	          </div>
	        </div>
        </div>

				<div class="mfn-row">
					<div class="row-column row-column-12">

					<div class="mfn-card mfn-shadow-1" data-card="integrations">
						<div class="card-header">
							<div class="card-title-group">
								<span class="card-icon mfn-icon-plugins"></span>
								<div class="card-desc">
									<h4 class="card-title">سازگاری های محبوب</h4>
								</div>
							</div>
						</div>
						<div class="card-content">
							<div class="mfn-row">

									<div class="row-column row-column-4 plugin-item">
										<img class="icon-light" src="<?php echo get_theme_file_uri('/functions/admin/assets/svg/plugins/integration-wprocket.svg'); ?>" alt="WPRocket" />
										<img class="icon-dark" src="<?php echo get_theme_file_uri('/functions/admin/assets/svg/_dark/plugins/integration-wprocket.svg'); ?>" alt="WPRocket" />
										<h5>افزونه موشک | Rocket</h5>
										<p>افزونه موشک | Rocket بسیار بیشتر از یک افزونه ذخیره سازی وردپرس است. این قدرتمندترین راه حل برای افزایش زمان بارگیری شما است.</p>
										<a class="mfn-btn btn-wide" target="_blank" href="https://www.zhaket.com/web/wp-rocket/?affid=AF-61328c9d6dfbe">
											<span class="btn-wrapper">خرید افزونه موشک </span>
										</a>
									</div>

									<div class="row-column row-column-4 plugin-item">
										<img class="icon-light" src="<?php echo get_theme_file_uri('/functions/admin/assets/svg/plugins/integration-wpml.svg'); ?>" alt="WPML" />
										<img class="icon-dark" src="<?php echo get_theme_file_uri('/functions/admin/assets/svg/_dark/plugins/integration-wpml.svg'); ?>" alt="WPML" />
										<h5>سایت های چند زبانه</h5>
										<p>افزونه ای که بیش از یک میلیون سایت وردپرس را چند زبانه می کند. برای سایت های شرکتی به اندازه کافی قدرتمند است، اما برای وبلاگ ها ساده است.</p>
										<a class="mfn-btn btn-wide" target="_blank" href="https://www.zhaket.com/web/wpml-multilingual-cms/?affid=AF-61328c9d6dfbe">
											<span class="btn-wrapper">خرید و دانلود</span>
										</a>
									</div>

									<div class="row-column row-column-4 plugin-item">
										<img class="icon-light" src="<?php echo get_theme_file_uri('/functions/admin/assets/svg/plugins/integration-hubspot.svg'); ?>" alt="HubSpot" />
										<img class="icon-dark" src="<?php echo get_theme_file_uri('/functions/admin/assets/svg/_dark/plugins/integration-hubspot.svg'); ?>" alt="HubSpot" />
										<h5>هاب اسپاد افزونه ای برای پشتیبانی و مارکتینگ </h5>
										<p> جموعه ابزار به متخصصان وردپرس کمک می کند تا بدون برنامه نویسی سایت های پیشرفته بسازند. هر آنچه نیاز دارید در یک بسته.</p>
										<a class="mfn-btn btn-wide" target="_blank" href="https://app.hubspot.com/signup-hubspot/crm?hubs_signup-cta=login-signup-cta&hubs_signup-url=app.hubspot.com%2Flogin">
											<span class="btn-wrapper">عضویت در هاب اسپات</span>
										</a>
									</div>

								</div>
							</div>
						</div>

					</div>
				</div>

				<?php endif; ?>

			<?php endif; ?>

    </div>

		<?php
			// footer
			include get_theme_file_path('/functions/admin/templates/parts/footer.php');
		?>

	</div>

	<!-- modal: data collection -->

  <div class="mfn-modal modal-medium modal-data-collection">
    <div class="mfn-modalbox mfn-form mfn-shadow-1">

			<div class="modalbox-header">

				<div class="options-group">
					<div class="modalbox-title-group">
						<span class="modalbox-icon mfn-icon-card"></span>
						<div class="modalbox-desc">
							<h4 class="modalbox-title"><?php esc_html_e('Data collection', 'mfn-opts'); ?></h4>
						</div>
					</div>
				</div>

				<div class="options-group">
					<a class="mfn-option-btn mfn-option-blank btn-large btn-modal-close" title="Close" href="#"><span class="mfn-icon mfn-icon-close"></span></a>
				</div>

			</div>

			<div class="modalbox-content">

				<span class="mfn-icon mfn-icon-support"></span>
				<h3><?php esc_html_e('Data collection', 'mfn-opts'); ?></h3>

				<p>Betheme هیچ اطلاعات شخصی را جمع آوری نمی کند. با این حال، ما برخی از اطلاعات اولیه در مورد وب سایت شما را برای تأیید مجوز و ثبت محصول شما جمع آوری می کنیم. اینها هستند:</p>

				<ul class="default">
					<li>کد خریدی که برای ثبت محصول استفاده شده است</li>
					<li>نام دامنه ای که وب سایت شما از آن استفاده می کند</li>
				</ul>

				<p>به منظور ارائه خدمات و بررسی به‌روزرسانی‌ها، هر از گاهی، نصب وردپرس شما یک اتصال ناشناس به سرورهای ما برقرار می‌کند.</p>

			</div>

    </div>

  </div>

</div>
